<?php

namespace App\Services\Users;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Users\User;
use App\Models\Users\UserModel;

class UpdateUserPersonalData
{
    public function __construct(
        private TransactionInterface $transaction
    ) {}

    public function update(User $user, UserModel $userModel): void
    {
        $this->transaction->begin();

        $user->setPersonalData(
            $userModel->getName(),
            $userModel->getSurname()
        );

        $this->transaction->end();
    }
}