<?php

namespace App\Services\Units;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Units\Unit;
use App\Models\Units\UpdateCardInfoModel;

class UpdateCardInfo
{
    public function __construct(
        private TransactionInterface $transaction
    ) {}

    public function update(Unit $unit, UpdateCardInfoModel $cardInfo): void
    {
        $this->transaction->begin();

        $unit->getCardInfo()
            ->updateContent(
                $cardInfo->getContent()
            );

        $this->transaction->end();
    }
}