<?php

namespace App\Services\Purposes;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Purposes\Purpose;
use App\Models\Purposes\UpdatePurposeModel;

class UpdatePurpose
{
    public function __construct(
        private TransactionInterface $transaction
    ) {}

    public function update(Purpose $purpose, UpdatePurposeModel $updatePurposeModel): void
    {
        $this->transaction->begin();

        $purpose->update(
            $updatePurposeModel->getTitle(),
            $updatePurposeModel->getMoney(),
            $updatePurposeModel->getStartedAt(),
            $updatePurposeModel->getContent()
        );

        $this->transaction->end();
    }
}