<?php

namespace App\Services\Posts;

use App\Core\File\ImageManager\ImageManagerInterface;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Posts\Factory\PostFactory;
use App\Entity\Posts\PostID;
use App\Entity\Posts\PostsInterface;
use App\Entity\Units\Unit;
use App\Models\Posts\PostModel;

class CreatePost
{
    public function __construct(
        private PostFactory $postFactory,
        private TransactionInterface $transaction,
        private ImageManagerInterface $imageManager,
        private PostsInterface $posts,
    ) {}

    public function create(PostModel $postModel, Unit $unit): PostID
    {
        $this->transaction->begin();

        $post = $this->postFactory->build($postModel, $unit);

        $image = $this->imageManager->prepare(
            $post->getPhoto(),
            $postModel->getPhoto()
        );
        $post->setPhoto($image);

        $this->posts->add($post);

        $this->transaction->end();

        return $post->getUuid();
    }
}