<?php

namespace App\Services\Orders\Webhooks;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Order;
use App\PaymentSystem\Przelewy24Interface;

class CardInfoForOrder
{
    public function __construct(
        private TransactionInterface $transaction,
        private Przelewy24Interface $p24,
    )
    {
    }

    public function cardInfo(Order $order)
    {
        $subscription = $order->getSubscription();

        $cardInfoNotification = $this->p24->handleCardInfo();

        $this->transaction->begin();

        $subscription->setMethodRefID($cardInfoNotification->getMethodRefId());

       $this->transaction->end();
    }
}