<?php

namespace App\Services\Orders;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Order;
use App\PaymentSystem\Przelewy24Interface;

class UpdateTransactionNumber
{
    public function __construct(
        private TransactionInterface $transaction,
        private Przelewy24Interface $p24,
    )
    {
    }

    public function update(Order $order)
    {

        $infoTransaction = $this->p24->transactionBySessionId((string)$order->getUuid());

        $this->transaction->begin();
        $order->setTransactionNumber($infoTransaction->getTransactionNumber());

        $this->transaction->end();
    }
}