<?php

namespace App\Services\Orders;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Subscriptions\Helper\ReasonForClosure;
use App\Entity\Subscriptions\Subscription;
use Psr\Log\LoggerInterface;

class SubscriptionExpired
{
    public function __construct(
        private TransactionInterface $transaction,
        private LoggerInterface $paymentLogger,
    )
    {
    }

    public function expired(Subscription $subscription)
    {
        $dateNow = new \DateTimeImmutable();


        $this->transaction->begin();

        $subscription->deactivate(ReasonForClosure::RENEWAL);

        $this->transaction->end();


        $this->paymentLogger->info('Success deactivation subscription:' . $subscription->getUuid() . 'with reason: '.ReasonForClosure::RENEWAL.' at date: ' . $dateNow->format("Y-m-d H:i:s"));
    }
}