<?php

namespace App\Services\Orders;

use App\Core\Exception\ApiException;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Classes\OrderManagerInterface;
use App\Entity\Orders\Order;
use App\Entity\Orders\OrdersInterface;
use App\Entity\Units\Unit;
use App\Models\Orders\OrderHearthAdoptionModel;
use App\PaymentSystem\PaymentTransaction;
use App\PaymentSystem\Przelewy24Interface;
use Symfony\Contracts\Translation\TranslatorInterface;

class CreateOrderForOneTimeHearthAdoption
{
    public function __construct(
        private TransactionInterface $transaction,
        private Przelewy24Interface $p24,
        private OrderManagerInterface $orderManager,
        private OrdersInterface $orders,
        private TranslatorInterface $translator,
    )
    {
    }

    public function hearthAdoptionOneTimeSubscription(OrderHearthAdoptionModel $orderHearthAdoptionModel, Unit $unit): string
    {
        if ($unit->getType()->isEmergency()) {
            throw new ApiException($this->translator->trans('unit.type'));
        }

        $order = $this->orderManager->createOneTimeSubscriptionOrder(
            $orderHearthAdoptionModel->getChildren(),
            $unit,
            $orderHearthAdoptionModel->getUser(),
            $orderHearthAdoptionModel->getMonths()
        );

        $paymentTransaction = PaymentTransaction::fromOrder($order);

        $paymentTransaction = $this->p24->transaction(
            $paymentTransaction
        );

        $order->setToken($paymentTransaction->token());


        $this->transaction->begin();

        $this->orders->add($order);

        $this->transaction->end();

        return $paymentTransaction->redirectUrl();
    }
}