<?php

namespace App\Services\Orders;


use App\Core\Exception\ApiException;
use App\Core\Transactions\TransactionInterface;
use App\Entity\Orders\Classes\OrderManagerInterface;
use App\Entity\Orders\OrdersInterface;
use App\Entity\Units\Unit;
use App\Models\Orders\OrderHearthAdoptionModel;
use App\Models\Orders\OrderPurposeModel;
use App\PaymentSystem\PaymentTransaction;
use App\PaymentSystem\Przelewy24Interface;
use Symfony\Contracts\Translation\TranslatorInterface;

class CreateOrderForCyclicHearthAdoption
{
    public function __construct(
        private TransactionInterface $transaction,
        private Przelewy24Interface $p24,
        private OrderManagerInterface $orderManager,
        private OrdersInterface $orders,
        private TranslatorInterface $translator,
    )
    {
    }

    public function hearthAdoptionCyclicSubscription(OrderHearthAdoptionModel $orderHearthAdoptionModel, Unit $unit): string
    {
        if ($unit->getType()->isEmergency()) {
            throw new ApiException($this->translator->trans('unit.type'));
        }

        $order = $this->orderManager->createCyclicSubscriptionOrder($orderHearthAdoptionModel->getChildren(), $unit, $orderHearthAdoptionModel->getUser());

        // TODO fix methodRefId generation
        $methodRefId = 'SALVATTI'.$order->getUuid();

        $paymentTransaction = PaymentTransaction::fromOrder($order)
            ->addMethodRefId($methodRefId)
            ->addChannel(PaymentTransaction::CHANNEL_CARD)
            ->addUrlCardNotification($order->getUrlCardInfo());

        $paymentTransaction = $this->p24->transaction(
            $paymentTransaction
        );
        $order->setToken($paymentTransaction->token());

        $order->getSubscription()->setMethodRefID($methodRefId);

        $order->getSubscription()->firstPayment();

        $this->transaction->begin();

        $this->orders->add($order);

        $this->transaction->end();

        return $paymentTransaction->redirectUrl();
    }
}