<?php

namespace App\Services\Galleries;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Images\Image;
use App\Models\Gallery\PhotoDetailsModel;

class UpdatePhoto
{
    public function __construct(
        private TransactionInterface $transaction
    ) {}

    public function update(Image $image, PhotoDetailsModel $photoGalleryDetailsModel): void
    {
        $this->transaction->begin();

        $image->setTitle(
            $photoGalleryDetailsModel->getTitle()
        );

        $this->transaction->end();
    }
}