<?php

namespace App\Services\Agreement;

use App\Core\Transactions\TransactionInterface;
use App\Entity\Agreement\Agreement;
use App\Entity\Agreement\ReadModel\AgreementsInterface;
use App\Entity\UserAgreementsHistory\Factory\UserAgreementHistoryFactory;
use App\Entity\UserAgreementsHistory\UserAgreementsHistoryInterface;
use App\Entity\Users\User;
use App\Models\Agreement\UserAgreementsModel;

class UpdateUserAgreement
{
    public function __construct(
        private TransactionInterface $transaction,
        private AgreementsInterface $agreements,
        private UserAgreementsHistoryInterface $agreementsHistory
    ) {}

    public function update(UserAgreementsModel $agreements, User $user, string $ip): void
    {
        $sentAgreement = $agreements->getAgreementsIDs();
        $userAgreement = $user->getAgreementsIDs();

        $toAdd = $this->findDifferenceBetween($sentAgreement, $userAgreement);
        $toRemove = $this->findDifferenceBetween($userAgreement, $sentAgreement);

        $this->transaction->begin();

        $agreementsToAdd = $this->agreements->findAllByIDs($toAdd);
        foreach ($agreementsToAdd as $agreement) {
            $user->addAgreement($agreement);
            $this->addToHistory($agreement, $user, false, $ip);
        }

        $agreementsToRemove = $this->agreements->findAllByIDs($toRemove);
        foreach ($agreementsToRemove as $agreement) {
            $user->removeAgreement($agreement);
            $this->addToHistory($agreement, $user, true, $ip);
        }

        $this->transaction->end();
    }

    private function findDifferenceBetween(array $array1, array $array2): array
    {
        return array_diff($array1, $array2);
    }

    private function addToHistory(Agreement $agreement, User $user, bool $status, string $ip): void
    {
        $this->agreementsHistory->add(
            UserAgreementHistoryFactory::create($agreement, $user, $status, $ip)
        );
    }
}