<?php

namespace App\ReportSystem;

use App\ReportSystem\Core\ExcelConfig;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Color;

class OrderReportConfig extends ExcelConfig
{
    const COMMERCIAL_AGREEMENT_EXIST = 'Tak';
    const COMMERCIAL_AGREEMENT_NOT_EXIST = 'Nie';
    protected array $styles = [
        'borders' => [
            'allBorders' => [
                'borderStyle' => Border::BORDER_THIN,
                'color' => [Color::COLOR_BLACK],
            ],
        ],
    ];

    protected array $columns = [
        'Id płatności',
        'Id zbiórki',
        'Nazwa zbiórki',
        'Id użytkownika',
        'Imię',
        'Nazwisko',
        'Adres e-mail',
        'Kod wolontariusza',
        'Typ płatności',
        'Data wpłaty',
        'Godzina wpłaty',
        'Kwota wpłaty',
        'Zgoda marketingowa',
        'Liczba miesięcy',
        'Numer transakcji'
    ];

    protected string $filename = 'OrderReport';


    public function __construct(array $data, string $publicDir, string $filename = null, array $extraColumns = [])
    {
        $this->data = $data;
        $this->columns = array_merge($this->columns, $extraColumns);
        $this->filename = $filename ?: $this->filename;
        $this->publicDir = $publicDir;
    }
}