<?php

namespace App\ReportSystem\Core;

use Symfony\Component\Filesystem\Exception\IOExceptionInterface;
use Symfony\Component\Filesystem\Filesystem;

class ExcelConfig implements PreparedDataInterface
{
    protected array $data = [];
    /**
     * @var array
     */
    protected array $styles = [];

    /**
     * @var array
     */
    protected array $columns = [];

    protected string $filename = 'report';

    protected string $publicDir;



    public function getData()
    {
        return [$this->columns, ...$this->data];
    }

    public function getStyles()
    {
        return $this->styles;
    }

    public function getFilepath()
    {
        $filesystem = new Filesystem();

        try {
            $filesystem->mkdir(
                $this->publicDir,
            );
        } catch (IOExceptionInterface $exception) {
            echo "An error occurred while creating your directory at " . $exception->getPath();
        }

        return $this->publicDir . $this->filename . '_' . date('d_m_y_G_i_s') . '.xlsx';
    }
}