<?php

namespace App\PaymentSystem;

use App\PaymentSystem\Api\Api;
use App\PaymentSystem\Api\Response\CardChargeResponse;
use App\PaymentSystem\Api\Response\InfoTransactionResponse;
use App\PaymentSystem\Api\Response\RegisterTransactionResponse;
use App\PaymentSystem\Api\Response\VerifyTransactionResponse;
use App\PaymentSystem\Exceptions\ApiResponseException;

class Przelewy24 implements Przelewy24Interface
{
    /**
     * @var Config
     */
    private $config;

    /**
     * @var Api
     */
    private $api;

    /**
     * @param string $merchantId
     * @param string $crc
     * @param string $apiKey
     * @param bool $isLiveMode
     */
    public function __construct(string $merchantId , string $crc, string $apiKey, bool $isLiveMode = false)
    {
        $this->config = new Config($merchantId, $crc, $apiKey, $isLiveMode);
        $this->api = new Api($this->config);
    }

    /**
     * @param PaymentTransaction $transaction
     * @return RegisterTransactionResponse
     * @throws ApiResponseException
     */
    public function transaction(PaymentTransaction $transaction): RegisterTransactionResponse
    {

        return $this->api->registerTransaction($transaction);
    }

    /**
     * @param TransactionVerification $verification
     * @return VerifyTransactionResponse
     * @throws ApiResponseException
     */
    public function verify(TransactionVerification $verification): VerifyTransactionResponse
    {
        return $this->api->verifyTransaction($verification);
    }

    /**
     * @return TransactionStatusNotification
     */
    public function handleWebhook(): TransactionStatusNotification
    {
        $data = json_decode(file_get_contents('php://input'), true);

        return new TransactionStatusNotification($data);
    }

    /**
     * @throws ApiResponseException
     */
    public function cardCharge(TransactionCardCharge $cardCharge): CardChargeResponse
    {
        return $this->api->cardChargeTransaction($cardCharge);
    }

    public function handleCardInfo(): CardInfoNotification
    {
        $data = json_decode(file_get_contents('php://input'), true);

        return new CardInfoNotification($data);
    }

    /**
     * @throws ApiResponseException
     */
    public function transactionBySessionId(string $sessionId): InfoTransactionResponse
    {
        return $this->api->transactionInfo($sessionId);
    }
}
