<?php

namespace App\Models\Users;

use App\Core\ParamConverter\JsonModelConverter;
use App\Entity\Units\UnitID;
use App\Entity\Units\Unit;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Validator\Constraints as Assert;
use App\Core\Validator as CustomAssert;

class UserUnitAssignModel implements JsonModelConverter
{
    /**
     * @Assert\All({
     *     @CustomAssert\EntityID(entityClass=Unit::class)
     * })
     * @var string[] $units
     */
    private array $units;

    /**
     * @param string[] $units
     */
    public function setUnits(array $units): void
    {
        $this->units = $units;
    }

    /**
     * @return UnitID[]
     */
    #[Ignore]
    public function getUnitsIDs(): array
    {
        return (new ArrayCollection($this->units))
            ->map(fn($unitId) => UnitID::fromString($unitId))
            ->toArray();
    }
}