<?php

namespace App\Models\SliderImages;

use App\Core\Utils\FromArray;
use App\Entity\SliderImages\SliderImageID;
use App\Entity\Units\UnitID;
use OpenApi\Annotations as OA;

class SliderImageModel
{
    use FromArray;

    private function __construct(
        private string $photoId,
        private int $orderNumber,
        private ?string $unitId = null,
        private ?string $description = null,
        private ?string $title = null
    )
    {
        $this->photoId = (string) SliderImageID::fromString($photoId);
    }

    /**
     * @return string
     */
    public function getPhotoId(): string
    {
        return $this->photoId;
    }

    /**
     * @return int
     */
    public function getOrderNumber(): int
    {
        return $this->orderNumber;
    }

    /**
     * @return UnitID|null
     *  @OA\Property(type="string"),
     */

    public function getUnitId(): ?UnitID
    {
        return $this->unitId ? UnitID::fromString($this->unitId) : null;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }
}