<?php

namespace App\Models\Orders;

use App\Core\Utils\Money;
use App\Entity\Users\User;
use Symfony\Component\Serializer\Annotation\Ignore;
use Symfony\Component\Validator\Constraints as Assert;

class OrderPurposeModel
{
    const DEFAULT = 'Default';
    const EMAIL_REQUIRED = 'email_required';

    #[Assert\NotBlank]
    #[Assert\Type(type: "float")]
    #[Assert\Range(min: 0.01, max: 100000)]
    private float $price;

    #[Assert\NotBlank(groups: [self::EMAIL_REQUIRED])]
    #[Assert\Email(groups: [self::EMAIL_REQUIRED])]
    private ?string $email;

    #[Ignore]
    private ?User $user;

    /**
     * @param float $price
     * @param string|null $email
     */
    public function __construct(float $price, ?string $email = null)
    {
        $this->price = $price;
        $this->email = $email;
    }


    /**
     * @return int
     */
    #[Ignore]
    public function getAmount(): int
    {
        return Money::toMinor($this->price);
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->user?$this->user->getEmail():$this->email;
    }

    /**
     * @param User|null $user
     */
    public function setUser(?User $user)
    {
        $this->user = $user;
    }

    /**
     * @return float
     */
    public function getPrice(): float
    {
        return $this->price;
    }

    /**
     * @return User|null
     */
    public function getUser(): ?User
    {
        return $this->user;
    }

    /**
     * @return string[]
     */
    #[Ignore]
    public function getValidationGroups(): array
    {
        $validationGroups = [self::DEFAULT];

        if(!$this->user)
            $validationGroups[] =self::EMAIL_REQUIRED;

        return  $validationGroups;
    }
}