<?php

namespace App\Entity\Users;

interface UsersInterface
{
    /**
     * @param User $user
     */
    public function add(User $user): void;

    /**
     * @param string $email
     * @return User|null
     */
    public function findOneByEmail(string $email): ?User;

    /**
     * @param string|null $token
     * @return User|null
     */
    public function findOneByToken(?string $token): ?User;

    /**
     * @param int $length
     * @return string
     */
    public function generateReferenceCode(int $length = 4): string;

}