<?php

namespace App\Entity\Users\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Roles\RoleID;
use App\Entity\Users\Helper\UserStatus;
use App\Entity\Users\UserID;
use Symfony\Component\Serializer\Annotation\Ignore;

class UserDTO
{
    use FromArray;

    private UserStatus $userStatus;

    public function __construct(
        private string $userId,
        private string $name,
        private string $surname,
        private string $email,
        private string $roleId,
        private string $roleName,
        private bool $isActive,
        private bool $isBlocked,
        private ?int $paymentSum = 0
    ) {
        $this->userId = (string) UserID::fromString($this->userId);
        $this->roleId = (string)RoleID::fromString($this->roleId);
        $this->userStatus = new UserStatus($this->isActive, $this->isBlocked);
    }

    /**
     * @return string
     */
    public function getUserId(): string
    {
        return $this->userId;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSurname(): string
    {
        return $this->surname;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getRoleId(): string
    {
        return $this->roleId;
    }


    /**
     * @return string
     */
    public function getRoleName(): string
    {
        return $this->roleName;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->userStatus->getStatus();
    }

    /**
     * @return float
     */
    public function getPaymentSum(): float
    {
        return Money::toRational($this->paymentSum);
    }
}