<?php

namespace App\Entity\Units\ReadModel\Helper;

use App\Entity\Units\Helper\Type as UnitType;

final class Type
{
    private static array $typesTranslations = [
        UnitType::INSTITUTION => 'Adopcja dzieci',
        UnitType::EMERGENCY => 'Emergency',
        UnitType::FAMILY => 'Rodzina'
    ];

    public function __construct(
        private string $type
    )
    {
    }

    public function getTypes(): array
    {
        return self::$typesTranslations;
    }

    public function __toString(): string
    {
        if (isset(self::$typesTranslations[$this->type]))
        {
            return self::$typesTranslations[$this->type];
        }

        return $this->getOriginalType();
    }

    public function getOriginalType(): string
    {
        return $this->type;
    }

}