<?php

namespace App\Entity\Units\Helper;

final class Type implements \JsonSerializable
{
    const INSTITUTION = 'I';
    const EMERGENCY = 'E';
    const FAMILY = 'F';

    const CHOICES = [
        self::INSTITUTION,
        self::EMERGENCY,
        self::FAMILY
    ];

    private static array $defaultDescription = [
        self::INSTITUTION => 'Adopcja dzieci',
        self::FAMILY => 'Wsparcie regularne'
    ];

    public function __construct(
        private string $type
    )
    {
    }

    public function isInstitution(): bool
    {
        return $this->type == self::INSTITUTION;
    }

    public function isEmergency(): bool
    {
        return $this->type == self::EMERGENCY;
    }

    public function isFamily(): bool
    {
        return $this->type == self::FAMILY;
    }

    public function hasSubscriptionOrders(): bool
    {
        return self::isInstitution() || self::isFamily();
    }

    public function getDefaultDescription(): ?string
    {
        if (isset(self::$defaultDescription[$this->type])) {
            return self::$defaultDescription[$this->type];
        }
        return null;
    }

    public function __toString(): string
    {
        return $this->type;
    }

    public function jsonSerialize(): string
    {
        return $this->type;
    }
}