<?php

namespace App\Entity\Subscriptions;

use App\Entity\Units\Unit;
use App\Entity\Users\User;

interface SubscriptionsInterface
{

    /**
     * @param \DateTimeImmutable|null $dateTime
     * @return Subscription[]
     */
    public function findAllToCharge(?\DateTimeImmutable $dateTime = null): array;

    /**
     * @param \DateTimeImmutable|null $dateTime
     * @return Subscription[]
     */
    public function findAllExpired(?\DateTimeImmutable $dateTime = null): array;

    /**
     * @return Subscription[]
     */
    public function findAllUnpaid(): array;

    /**
     * @param User $user
     * @return Subscription[]
     */
    public function findAllActiveByUser(User $user): array;

    /**
     * @param Unit $unit
     * @return Subscription[]
     */
    public function findAllActiveByUnit(Unit $unit): array;

    /**
     * @return Subscription[]
     */
    public function findAllToRemind(): array;
}