<?php

namespace App\Entity\Subscriptions\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Subscriptions\SubscriptionID;
use App\Entity\Units\UnitID;

class SubscriptionDTO
{
    use FromArray;

    public function __construct(
        private string $subscriptionId,
        private string $unitId,
        private string $unitTitle,
        private string $unitType,
        private int $subscriptionMonthlyCost,
        private int $unitMonthlyCost,
        private int $subscriptionChildren,
        private string $dateEnd
    )
    {
        $this->subscriptionId = (string)SubscriptionID::fromString($this->subscriptionId);
        $this->unitId = (string)UnitID::fromString($this->subscriptionId);
    }

    /**
     * @return string
     */
    public function getSubscriptionId(): string
    {
        return $this->subscriptionId;
    }

    /**
     * @return string
     */
    public function getUnitId(): string
    {
        return $this->unitId;
    }

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return string
     */
    public function getUnitType(): string
    {
        return $this->unitType;
    }

    /**
     * @return float
     */
    public function getSubscriptionMonthlyCost(): float
    {
        return Money::toRational($this->subscriptionMonthlyCost);
    }

    /**
     * @return float
     */
    public function getUnitMonthlyCost(): float
    {
        return Money::toRational($this->unitMonthlyCost);
    }

    /**
     * @return int
     */
    public function getSubscriptionChildren(): int
    {
        return $this->subscriptionChildren;
    }

    /**
     * @return string
     * @throws \Exception
     */
    public function getDateEnd(): string
    {
        return (new \DateTimeImmutable($this->dateEnd))->format('Y-m-d');
    }
}