<?php

namespace App\Entity\SliderImages;

use App\Entity\Sliders\Slider;
use App\Entity\Units\Unit;
use Doctrine\ORM\Mapping as ORM;
use PhpParser\Node\Expr\Closure;
use Symfony\Component\Uid\Uuid;

/**
 * @ORM\Entity()
 */
class SliderImage
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private SliderImageID|Uuid $uuid;

    /**
     * @ORM\Column(type="integer")
     */
    private int $orderNumber;

    /**
     * @ORM\ManyToOne(targetEntity=Unit::class)
     * @ORM\JoinColumn(name="unit_id", referencedColumnName="uuid", nullable=true)
     */
    private ?Unit $unit;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private string $image;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private ?string $description;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private ?string $title;

    /**
     * @ORM\Column(type="datetime_immutable")
     */
    private \DateTimeImmutable $createdAt;

    /**
     * @ORM\ManyToOne(targetEntity=Slider::class, inversedBy="sliderImages")
     * @ORM\JoinColumn(name="slider_id", referencedColumnName="uuid", nullable=false)
     */
    private Slider $slider;

    public function __construct(Slider $slider, string $image, int $orderNumber)
    {
        $this->uuid = SliderImageID::generate();
        $this->slider = $slider;
        $this->orderNumber = $orderNumber;
        $this->image = $image;
        $this->createdAt = new \DateTimeImmutable();
    }

    /**
     * @return SliderImageID
     */
    public function getUuid(): SliderImageID
    {
        return SliderImageID::fromString($this->uuid);
    }

    /**
     * @return string
     */
    public function getImage(): string
    {
        return $this->image;
    }

    /**
     * @return int
     */
    public function getOrderNumber(): int
    {
        return $this->orderNumber;
    }

    /**
     * @param int $orderNumber
     */
    public function setOrderNumber(int $orderNumber): void
    {
        $this->orderNumber = $orderNumber;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getCreatedAt(): \DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function getUnit(): ?Unit
    {
        return $this->unit;
    }

    public function setUnit(?Unit $unit): self
    {
        $this->unit = $unit;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }


    /**
     * @param string|null $description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }


    /**
     * @param string|null $title
     */
    public function setTitle(?string $title): void
    {
        $this->title = $title;
    }

    public function getSlider(): ?Slider
    {
        return $this->slider;
    }

    public function setSlider(?Slider $slider): self
    {
        $this->slider = $slider;

        return $this;
    }

    public function decreaseOrderNumber(): void
    {
        $this->orderNumber--;
    }
}
