<?php

namespace App\Entity\Reports\ReadModel;

use App\Core\Utils\FromArray;
use Symfony\Component\Notifier\Recipient\EmailRecipientInterface;

class QuarterReportRecipientDTO implements EmailRecipientInterface
{
    use FromArray;


    public function __construct(
        private string $email,
        private string $userName,
        private string $userSurname
    )
    {
    }

    public function getEmail(): string
    {
       return $this->email;
    }

    /**
     * @return string
     */
    public function getUserName(): string
    {
        return $this->userName;
    }

    /**
     * @return string
     */
    public function getUserSurname(): string
    {
        return $this->userSurname;
    }
}