<?php

namespace App\Entity\Reports\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Posts\PostID;
use App\Entity\Units\UnitID;

class QuarterReportDTO
{

    use FromArray;

    public function __construct(
        private string $unitID,
        private string $unitTitle,
        private string $dateStart,
        private string $dateEnd,
        private string $createdAt,
        private string $description,
        private string $postID
    )
    {
        $this->unitID = (string)UnitID::fromString($unitID);
        $this->postID = (string)PostID::fromString($postID);
    }

    /**
     * @return string
     */
    public function getUnitID(): string
    {
        return $this->unitID;
    }


    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    /**
     * @return string
     */
    public function getDateStart(): string
    {
        return (new \DateTimeImmutable($this->dateStart))->format('Y-m-d');
    }

    /**
     * @return string
     */
    public function getDateEnd(): string
    {
        return (new \DateTimeImmutable($this->dateEnd))->format('Y-m-d');
    }

    /**
     * @return string
     */
    public function getCreatedAt(): string
    {
        return (new \DateTimeImmutable($this->createdAt))->format('Y-m-d H:i');
    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @return string
     */
    public function getPostID(): string
    {
        return $this->postID;
    }
}