<?php

namespace App\Entity\Purposes\ReadModel;

use App\Entity\Purposes\PurposeID;
use App\Entity\Units\UnitID;

interface PurposesQueryInterface
{
    /**
     * @param UnitID $unitID
     * @return GoalsListDTO|null
     */
    public function findGoalsListByUnitId(UnitID $unitID): ?GoalsListDTO;

    /**
     * @param PurposeID $purposeID
     * @return PurposeDTO|null
     */
    public function findOnePurposeById(PurposeID $purposeID): ?PurposeDTO;
}