<?php

namespace App\Entity\Purposes\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;

class PurposeDTO
{
    use FromArray;

    public function __construct(
        private string $title,
        private int $money,
        private string $startedAt,
        private string $content
    ) {}

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @return float
     */
    public function getMoney(): float
    {
        return Money::toRational($this->money);
    }

    /**
     * @return string
     */
    public function getStartedAt(): string
    {
        return $this->startedAt;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }
}