<?php

namespace App\Entity\Posts\Factory;

use App\Entity\Contents\Content;
use App\Entity\Posts\Post;
use App\Entity\Posts\PostID;
use App\Entity\Units\Unit;
use App\Models\Posts\PostModel;

class PostFactory
{
    public function build(PostModel $postModel, Unit $unit): Post
    {
        return new Post(
            PostID::generate(),
            $unit,
            $postModel->getTitle(),
            $postModel->getDescription(),
            new Content($postModel->getContent())
        );
    }
}