<?php

namespace App\Entity\Permissions\ReadModel;

use App\Core\Utils\FromArray;
use App\Entity\Permissions\PermissionID;

class PermissionDTO
{
    use FromArray;
    
    public function __construct(
        private string $uuid,
        private string $name,
        private string $authorization
    )
    {
        $this->uuid = (string)PermissionID::fromString($this->uuid);
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getAuthorization(): string
    {
        return $this->authorization;
    }


}