<?php

namespace App\Entity\Payments;

use App\Entity\Orders\Order;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\Entity;
use Symfony\Component\Uid\Uuid;

/**
 * @Entity()
 */
class Payment
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private PaymentID|Uuid $uuid;

    /**
     * @ORM\ManyToOne(targetEntity=Order::class)
     * @ORM\JoinColumn(name="order_id", referencedColumnName="uuid", nullable=true)
     */
    private Order $order;

    /**
     * @ORM\Column(type="integer")
     */
    private int $amount;

    /**
     * @ORM\Column(type="datetime_immutable")
     */
    private \DateTimeImmutable $createdAt;

    /**
     * @param Order $order
     * @param int $amount
     */
    public function __construct(Order $order, int $amount, ?\DateTimeImmutable $createdAt = null)
    {
        $this->uuid = PaymentID::generate();
        $this->order = $order;
        $this->amount = $amount;
        $this->createdAt = $createdAt?:new \DateTimeImmutable();
    }

    /**
     * @param int $months
     * @return Payment
     * @throws \Exception
     */
    public function simulateCreatedAt(int $months): Payment
    {
        $this->createdAt = $this->createdAt->add(new \DateInterval('P' . $months . 'M'));
        return $this;
    }




}