<?php

namespace App\Entity\Orders\ReadModel;

use App\Entity\Users\UserID;
use Doctrine\DBAL\Query\QueryBuilder;

interface OrdersSubQueryInterface
{
    public function collectedMoneyQuery(): QueryBuilder;

    public function collectedMoneyInUnitChildrenQuery(): QueryBuilder;

    public function supportedChildrenQuery(): QueryBuilder;

    public function ordersAmount(?\DateTimeImmutable $dateStart = null, ?\DateTimeImmutable $dateEnd = null): QueryBuilder;

    public function ordersAmountByUserAndYear(UserID $userID, ?int $year = null): QueryBuilder;
}