<?php

namespace App\Entity\Orders\ReadModel;

use App\Core\Utils\FromArray;
use App\Core\Utils\Money;
use App\Entity\Orders\OrderID;
use App\Entity\Units\UnitID;

class OrderDTO
{
    use FromArray;


    public function __construct(
        private string $orderId,
        private string $createdAt,
        private string $status,
        private string $action,
        private int $amount,
        private string $unitId,
        private string $unitTitle,
    )
    {
        $this->orderId = (string)OrderID::fromString($this->orderId);
        $this->unitId = (string)UnitID::fromString($this->unitId);
    }

    /**
     * @return string
     */
    public function getOrderId(): string
    {
        return $this->orderId;
    }

    /**
     * @return string
     */
    public function getCreatedAt(): string
    {
        return $this->createdAt;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getAction(): string
    {
        return $this->action;
    }

    /**
     * @return string
     */
    public function getUnitId(): string
    {
        return $this->unitId;
    }

    /**
     * @return string
     */
    public function getUnitTitle(): string
    {
        return $this->unitTitle;
    }

    public function getPrice(): float
    {
        return Money::toRational($this->amount);
    }
}