<?php

namespace App\Entity\Images;

use App\Entity\Units\UnitID;

interface ImagesInterface
{
    /**
     * @param Image $image
     */
    public function add(Image $image): void;

    /**
     * @param Image $image
     */
    public function remove(Image $image): void;

    /**
     * @param ImageID $imageID
     * @param UnitID $unitID
     * @return Image
     */
    public function findPhotoToEdit(ImageID $imageID, UnitID $unitID): Image;

    /**
     * @param array $imagesIDs
     * @param UnitID $unitID
     * @return array
     */
    public function findPhotosToDelete(array $imagesIDs, UnitID $unitID): array;
}