<?php

namespace App\Entity\Images;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\Entity;
use Symfony\Component\Uid\Uuid;
use App\Entity\Units\Unit;

/**
 * @Entity()
 */
class Image
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private ImageID|Uuid $uuid;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private string $image;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private ?string $title;

    /**
     * @ORM\ManyToOne(targetEntity=Unit::class)
     * @ORM\JoinColumn(name="unit_id", referencedColumnName="uuid", nullable=true)
     */
    private ?Unit $unit;

    /**
     * @ORM\Column(type="datetime_immutable")
     */
    private \DateTimeImmutable $createdAt;

    /**
     * @param string $image
     */
    public function __construct(string $image)
    {
        $this->uuid = ImageID::generate();
        $this->image = $image;
        $this->createdAt = new \DateTimeImmutable();
    }

    /**
     * @return ImageID
     */
    public function getUuid(): ImageID
    {
        return ImageID::fromString($this->uuid);
    }

    /**
     * @return string
     */
    public function getImage(): string
    {
        return $this->image;
    }

    /**
     * @param string $image
     */
    public function updateImage(string $image): void
    {
        $this->image = $image;
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @return Unit|null
     */
    public function getUnit(): ?Unit
    {
        return $this->unit;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getCreatedAt(): \DateTimeImmutable
    {
        return $this->createdAt;
    }

    /**
     * @param string|null $title
     */
    public function setTitle(?string $title): void
    {
        $this->title = $title;
    }

    /**
     * @param Unit|null $unit
     */
    public function setUnit(?Unit $unit): void
    {
        $this->unit = $unit;
    }




}