<?php

namespace App\Entity\Images\Factory;

use App\Core\File\FileToUpload\FileToUploadInterface;
use App\Entity\Images\Image;
use App\Entity\Units\Unit;

class ImageFactory
{
    public static function create(FileToUploadInterface $fileToUpload): Image
    {
        return new Image($fileToUpload->getUniqueName());
    }

    public static function createGallery(Unit $unit, FileToUploadInterface $fileToUpload): Image
    {
        $image = new Image($fileToUpload->getUniqueName());
        $image->setUnit($unit);

        return $image;
    }
}