<?php

namespace App\Entity\Contents;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\Entity;
use Symfony\Component\Uid\Uuid;

/**
 * @Entity()
 */
class Content
{
    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private ContentID|Uuid $uuid;

    /**
     * @var string
     * @ORM\Column(type="text")
     */
    private string $content;

    /**
     * @param string $content
     */
    public function __construct(string $content)
    {
        $this->uuid = ContentID::generate();
        $this->content = $content;
    }

    /**
     * @return ContentID
     */
    public function getUuid(): ContentID
    {
        return ContentID::fromString($this->uuid);
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     */
    public function updateContent(string $content): void
    {
        $this->content = $content;
    }
}