<?php

namespace App\Entity\BalanceOperations\EventSubscribers;

use App\Entity\BalanceOperations\Classes\BalanceOperationsManagerInterface;
use App\Entity\Orders\Events\OrderVerifyEvent;
use App\Entity\Orders\Order;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class BalanceOperationSubscriber implements EventSubscriberInterface
{

    public function __construct(public BalanceOperationsManagerInterface $balanceOperationsManager)
    {
    }

    public static function getSubscribedEvents()
    {
        return [
            OrderVerifyEvent::NAME => 'onOrderVerify'
        ];
    }

    public function onOrderVerify(OrderVerifyEvent $event)
    {
        $this->createBalanceOperation($event->getOrder());
    }

    private function createBalanceOperation(Order $order)
    {
        if ($order->hasVolunteer())
            $this->balanceOperationsManager->createBalanceOperationFromOrder($order);
    }
}