<?php

namespace App\Entity\Agreement;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\Entity;
use Symfony\Component\Uid\Uuid;

/**
 * @Entity()
 */
class Agreement
{
    const COMMERCIAL_INFORMATION = 'COMMERCIAL_INFORMATION';
    const ONE_TIME_SUBSCRIPTION_EXPIRING = 'ONE_TIME_SUBSCRIPTION_EXPIRING';
    const CARD_WITHDRAW_PROBLEM = 'CARD_WITHDRAW_PROBLEM';
    const QUARTERLY_REPORT_SUPPORTED_UNIT = 'QUARTERLY_REPORT_SUPPORTED_UNIT';
    const ANNUAL_PAYMENT_REPORT = 'ANNUAL_PAYMENT_REPORT';

    /**
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    private AgreementID|Uuid $uuid;

    /**
     * @ORM\Column(type="string")
     */
    private string $originalName;

    /**
     * @ORM\Column(type="text")
     */
    private string $name;

    /**
     * @ORM\Column(type="boolean", options={"default": 0})
     */
    private bool $isRequired = false;

    /**
     * @ORM\Column(type="datetime_immutable")
     */
    private \DateTimeImmutable $createdAt;

    /**
     * @param string $originalName
     * @param string $name
     */
    public function __construct(string $originalName, string $name)
    {
        $this->uuid = AgreementID::generate();
        $this->originalName = $originalName;
        $this->name = $name;
        $this->createdAt = new \DateTimeImmutable();
    }

    /**
     * @return AgreementID
     */
    public function getUuid(): AgreementID
    {
        return AgreementID::fromString($this->uuid);
    }

    /**
     * @return string
     */
    public function getOriginalName(): string
    {
        return $this->originalName;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return bool
     */
    public function isRequired(): bool
    {
        return $this->isRequired;
    }

    /**
     * @param bool $isRequired
     */
    public function setIsRequired(bool $isRequired): void
    {
        $this->isRequired = $isRequired;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getCreatedAt(): \DateTimeImmutable
    {
        return $this->createdAt;
    }
}