<?php

namespace App\DataFixtures;

use App\Entity\Permissions\Permission;
use App\Entity\Roles\Factory\RoleFactory;
use App\Entity\Roles\Role;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Persistence\ObjectManager;

class RoleFixtures extends Fixture implements OrderedFixtureInterface
{
    private const ROLES = [
        'Administrator' => Role::ADMIN,
        'Redaktor zbiórek' => Role::EDITOR,
        'Patron' => Role::USER,
        'Redaktor Partnera' => Role::REDACTOR_PARTNER
    ];

    public function load(ObjectManager $manager): void
    {
        $repository = $manager->getRepository(Permission::class);

        foreach (self::ROLES as $name => $originalName) {
            $role = RoleFactory::create($name, $originalName);

            $permissions = match ($originalName) {
                Role::ADMIN => $repository->findAll(),
                Role::EDITOR => $repository->findBy(['authorization' => Permission::EDITOR_PERMISSIONS]),
                Role::USER => $repository->findBy(['authorization' => Permission::USER_PERMISSIONS]),
                Role::REDACTOR_PARTNER => $repository->findBy(['authorization' => Permission::REDACTOR_PARTNER_PERMISSIONS])
            };
            $this->addPermissionToRole($role, $permissions);

            $manager->persist($role);
        }

        $manager->flush();
    }

    private function addPermissionToRole(Role $role, array $permissions): void
    {
        foreach ($permissions as $permission) {
            $role->addPermission($permission);
        }
    }

    public function getOrder(): int
    {
        return 2;
    }
}