<?php

namespace App\DataFixtures;

use App\Entity\Permissions\Permission;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Persistence\ObjectManager;

class PermissionFixtures extends Fixture implements OrderedFixtureInterface
{
    private const PERMISSIONS = [
        'Administrowanie użytkownikami' => Permission::USERS_ADMINISTRATION,
        'Zarządzanie danymi konta' => Permission::ACCOUNT_DATA_MANAGEMENT,
        'Wolontariat' => Permission::VOLUNTEERING_MANAGEMENT,
        'Administrowanie zbiórkami' => Permission::UNIT_ADMINISTRATION,
        'Zarządzanie płatnościami' => Permission::PAYMENTS_MANAGEMENT,
        'Płatność na adopcję serca' => Permission::HEART_ADOPTION_PAYMENT,
        'Redagowanie zbiórek' => Permission::UNIT_REDACTION,
    ];

    public function load(ObjectManager $manager): void
    {
        foreach (self::PERMISSIONS as $name => $authorization) {
            $manager->persist(
                new Permission($name, $authorization)
            );
        }

        $manager->flush();
    }

    public function getOrder(): int
    {
        return 1;
    }
}