<?php

namespace App\Core\Validator;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Uid\UuidV4;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class EntityIDValidator extends ConstraintValidator
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {}

    public function validate($value, Constraint $constraint)
    {
        $entityClass = $constraint->entityClass;

        if(is_array($constraint->entityClass)) {
            $entityClass = $constraint->entityClass['entityClass'];
        }

        $entity = $this->entityManager->getRepository($entityClass)->findOneBy([
            'uuid' => UuidV4::fromString($value)
        ]);
        if (!$entity) {
            $this->context->buildViolation($constraint->message)
                ->setParameter('{{ uuid }}', $value)
                ->setParameter('{{ entity }}', $entityClass)
                ->addViolation();
        }
    }
}