<?php


namespace App\Core\Users;


use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use Symfony\Component\Security\Core\User\UserInterface;

class EncodePassword implements EncodePasswordInterface
{
    /**
     * EncodePassword constructor.
     * @param UserPasswordEncoderInterface $passwordEncoder
     */
    public function __construct(
        private UserPasswordEncoderInterface $passwordEncoder
    )
    {
    }

    public function encodePassword(UserInterface $user, string $plainPassword): string
    {
        return $this->passwordEncoder->encodePassword($user, $plainPassword);
    }
}