<?php

namespace App\Core\UrlGenerator;

use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class CustomUrlGenerator
{
    const SCHEMA_HTTPS = 'https:';
    const SCHEMA_HTTP = 'http:';

    public string $schema;

    public function __construct(
        public UrlGeneratorInterface $urlGenerator,
        public string $frontendUrl,
        public string $env
    )
    {
        if ($this->isProductionMode())
            $this->schema = self::SCHEMA_HTTPS;
        else
            $this->schema = self::SCHEMA_HTTP;
    }

    private function isProductionMode(): bool
    {
        return $this->env === 'prod';
    }

}