<?php

namespace App\Core\ParamConverter;

use App\Core\ValidatorModel\ValidatorModelInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Request\ParamConverter\ParamConverterInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Serializer\SerializerInterface;

final class JsonDeserializeParamConverter extends AbstractParamConverter implements ParamConverterInterface
{
    private const SUPPORT_INTERFACE = JsonModelConverter::class;

    public function __construct(
        private SerializerInterface $serializer,
        private ValidatorModelInterface $validatorModel
    )
    {
    }

    public function apply(Request $request, ParamConverter $configuration): void
    {
        $modelClass = $this->serializer->deserialize($request->getContent(), $configuration->getClass(), 'json');

        $groups = $configuration->getOptions()['groups'] ?? null;
        $this->validatorModel->validate(value: $modelClass, groups: $groups);

        $request->attributes->set($configuration->getName(), $modelClass);
    }

    public function supports(ParamConverter $configuration): bool
    {
        return $configuration->getClass() && self::hasAccess($configuration->getClass(), self::SUPPORT_INTERFACE);
    }
}