<?php

namespace App\Core\Notification;

use App\Core\Notification\Adapter\EmailNotification;
use App\Entity\Users\User;
use Symfony\Component\Notifier\NotifierInterface;
use Symfony\Component\Notifier\Recipient\EmailRecipientInterface;
use Symfony\Component\Notifier\Recipient\Recipient;

class NotifierManager implements NotifierManagerInterface
{

    public function __construct(public NotifierInterface $notifier)
    {
    }

    public function sendMail(string $subject, array $context, string $template, EmailRecipientInterface $recipient): void
    {
        $notification = (new EmailNotification($subject))
            ->context($context)
            ->template($template);

        $this->notifier->send($notification, new Recipient($recipient->getEmail()));
    }
}