<?php

namespace App\Core\Notification\Adapter;

use Symfony\Bridge\Twig\Mime\NotificationEmail;
use Symfony\Component\Notifier\Message\EmailMessage;
use Symfony\Component\Notifier\Notification\EmailNotificationInterface;
use Symfony\Component\Notifier\Notification\Notification;
use Symfony\Component\Notifier\Recipient\EmailRecipientInterface;

class EmailNotification extends Notification implements EmailNotificationInterface
{
    private array $context = [];
    private string $template = '';

    public function __construct(string $subject)
    {
        parent::__construct($subject, ['email']);
    }

    public function asEmailMessage(EmailRecipientInterface $recipient, string $transport = null): ?EmailMessage
    {
        $email = NotificationEmail::asPublicEmail()
            ->to($recipient->getEmail())
            ->subject($this->getSubject())
            ->context($this->getContext())
            ->htmlTemplate($this->getTemplate());

        return new EmailMessage($email);
    }

    /**
     * @return array
     */
    public function getContext(): array
    {
        return $this->context;
    }

    /**
     * @param array $context
     * @return EmailNotification
     */
    public function context(array $context): self
    {
        $this->context = $context;
        return $this;
    }

    /**
     * @return string
     */
    public function getTemplate(): string
    {
        return $this->template;
    }

    /**
     * @param string $template
     * @return EmailNotification
     */
    public function template(string $template): self
    {
        $this->template = $template;
        return $this;
    }
}