<?php

namespace App\Core\File\ImageManager;

use App\Core\File\FileRemover\FileRemoverInterface;
use App\Core\File\FileToUpload\FileToUploadInterface;
use App\Core\File\FileUploader\FileUploaderInterface;
use App\Entity\Images\Factory\ImageFactory;
use App\Entity\Images\Image;
use App\Entity\Images\ImagesInterface;

class ImageManager implements ImageManagerInterface
{
    public function __construct(
        private FileRemoverInterface $fileRemover,
        private FileUploaderInterface $fileUploader,
        private ImagesInterface $images
    ) {}

    public function prepare(?Image $image = null, ?FileToUploadInterface $imageToUpload = null): ?Image
    {
        if ($imageToUpload) {
            if ($image) {
                $this->fileRemover->remove($image->getImage());
                $this->images->remove($image);
            }

            $this->fileUploader->upload($imageToUpload);
            return ImageFactory::create($imageToUpload);
        }

        return $image;
    }
}