<?php

namespace App\Core\File\FileRemover;

use Symfony\Component\Filesystem\Filesystem;

class FileRemover implements FileRemoverInterface
{
    public function __construct(
        private string $fileUploadDir,
        private Filesystem $filesystem
    ) {}

    public function remove(string $fileName): void
    {
        $filePath = $this->fileUploadDir . $fileName;
        $this->filesystem->remove($filePath);
    }
}