<?php

namespace App\Core\Exception;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Http\EntryPoint\AuthenticationEntryPointInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

class AuthenticationEntryPoint implements AuthenticationEntryPointInterface
{
    public function __construct(
        private TranslatorInterface $translator
    ) {}

    /**
     * @throws ApiException
     */
    public function start(Request $request, AuthenticationException $authException = null): void
    {
        throw new ApiException(
            $this->translator->trans('authorization.access_denied'),
            Response::HTTP_UNAUTHORIZED
        );
    }
}